#pragma once
#include "../DXFramework/DXF.h"
#include "BowerMesh.h"

//Mesh used to represent the skybox
class Skybox : public BowerMesh
{
	public:
		Skybox(ID3D11Device* device, ID3D11DeviceContext* deviceContext);
		~Skybox();

		void initBuffers(ID3D11Device * device) override;

	private:
		void CreateShape();	//Creates the skybox itself

		//Creates all the individual faces of the skybox
		void CreateFrontFace();
		void CreateBackFace();
		void CreateLeftFace();
		void CreateRightFace();
		void CreateTopFace();
		void CreateBottomFace();

		//Mesh info
		VertexType* _Vertices;
		long* _Indices;
		ID3D11Device* _Device;
		VertexType topLeft;
		VertexType topRight;
		VertexType bottomLeft;
		VertexType bottomRight;
};

